<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover" />
  <title>Youht Mdc Jombang (by scard-project)</title>
  <meta name="theme-color" content="#1b0b24" />
  <script src="https://unpkg.com/html5-qrcode" defer></script>
  <style>
    :root{
      --radius: 22px;
      --glass-bg: rgba(255,255,255,0.12);
      --glass-stroke: rgba(255,255,255,0.25);
      --txt: #f7f8fa;
      --muted: #c9d0da;
      --accent: #a259ff;
    }
    *{box-sizing:border-box}
    html,body{height:100%;}
    body{
      margin:0;
      font-family:-apple-system,BlinkMacSystemFont,Segoe UI,Roboto,Helvetica,Arial;
      color:var(--txt);
      background:
        radial-gradient(1200px 800px at 10% 10%, #3c1c4f 0%, #0a0a0f 40%),
        radial-gradient(1000px 1000px at 90% 30%, #6a1b9a 0%, #0a0a0f 50%),
        radial-gradient(900px 900px at 50% 100%, #9c27b0 0%, #0a0a0f 50%);
      background-attachment:fixed;
      overflow-x:hidden;
    }
    .aurora{
      position:fixed; inset:-20% -20% auto -20%;
      height:70vh; filter:blur(50px); opacity:.65;
      background:conic-gradient(from 90deg,#a259ff,#ff2e92,#7b2ff7,#ff00c8,#a259ff);
      mix-blend-mode:screen; animation:spin 40s linear infinite; pointer-events:none;
    }
    @keyframes spin{to{transform:rotate(360deg)}}
    .wrap{min-height:100%; display:grid; place-items:center; padding:24px;}
    .card{
      width:min(960px,100%); border-radius:var(--radius);
      background:var(--glass-bg); border:1px solid var(--glass-stroke);
      box-shadow:0 10px 30px rgba(0,0,0,.35);
      backdrop-filter:blur(18px) saturate(130%);
      -webkit-backdrop-filter:blur(18px) saturate(130%);
      padding:clamp(16px,3vw,28px);
    }
    .topbar{display:flex; justify-content:space-between; align-items:center; border-bottom:1px solid rgba(255,255,255,.08); padding-bottom:12px;}
    .brand{display:flex; align-items:center; gap:12px}
    .logo{
      width:40px; height:40px; border-radius:12px; background:linear-gradient(135deg,#a259ff,#ff2e92);
      display:grid; place-items:center; color:white; font-weight:700; box-shadow:0 6px 18px rgba(162,89,255,.45)
    }
    .title{font-weight:700; font-size:clamp(18px,2.6vw,24px)}
    .muted{color:var(--muted); font-size:14px}
    .btn, select, input[type=file]{
      appearance:none; border-radius:14px; border:1px solid rgba(255,255,255,.2);
      background:rgba(255,255,255,.08); padding:10px 14px; color:var(--txt);
      font-weight:600; cursor:pointer; backdrop-filter:blur(12px);
    }
    .btn:hover{background:rgba(255,255,255,.15)}
    .btn:active{transform:translateY(1px)}
    .grid{display:grid; grid-template-columns:1fr 1fr; gap:16px; margin-top:16px}
    @media(max-width:900px){.grid{grid-template-columns:1fr}}
    .pane{border-radius:calc(var(--radius)-6px); background:rgba(0,0,0,.3); border:1px solid rgba(255,255,255,.12); position:relative; overflow:hidden}
    #reader{width:100%; height:min(64vh,520px)}
    .overlay{position:absolute; inset:0; display:grid; place-items:center; pointer-events:none}
    .box{
      width:min(80vmin,400px); height:min(80vmin,400px);
      border:2px solid rgba(255,255,255,.75); border-radius:22px; position:relative;
      box-shadow:0 0 0 200vmax rgba(0,0,0,.55)
    }
    .laser{position:absolute; left:0; right:0; height:2px; background:linear-gradient(90deg,transparent,white,transparent); animation:sweep 2.5s ease-in-out infinite}
    @keyframes sweep{0%{top:10%}50%{top:90%}100%{top:10%}}
    .log{background:rgba(0,0,0,.35); border-radius:14px; padding:12px; border:1px dashed rgba(255,255,255,.18); color:#e7dff5; font-family:ui-monospace,Menlo,Consolas,monospace; font-size:13px; max-height:180px; overflow:auto}
    .stat{display:flex; align-items:center; gap:10px; margin-top:8px; color:#e7dff5}
    .modal{position:fixed; inset:0; display:none; place-items:center; background:rgba(10,10,15,.6); z-index:50}
    .modal.show{display:grid}
    .sheet{width:min(560px,92vw); border-radius:26px; padding:22px; text-align:center; background:rgba(255,255,255,.12); backdrop-filter:blur(18px) saturate(150%); animation:up .35s ease forwards; box-shadow:0 10px 40px rgba(0,0,0,.5)}
    @keyframes up{to{transform:translateY(0)}}
    .avatar{width:110px; height:110px; border-radius:28px; overflow:hidden; margin:0 auto 14px}
    .avatar img{width:100%; height:100%; object-fit:cover}
    .big{font-size:clamp(22px,4.5vw,32px); font-weight:800}
    .hint{color:var(--muted); font-size:14px}
    .countdown{margin-top:10px; font-size:14px; color:#ffe0ff}
  </style>
</head>
<body>
  <div class="aurora"></div>
  <div class="wrap">
    <div class="card">
      <div class="topbar">
        <div class="brand">
          <div class="logo">QR</div>
          <div>
            <div class="title">Kehadiran peserta youht</div>
            <div class="muted">By mdcjombang.id</div>
          </div>
        </div>
        <div>
          <select id="cameraSelect" title="Pilih kamera"></select>
          <button class="btn" id="btnSwitch" title="Ganti kamera">ðŸ”„</button>
          <label class="btn" for="fileInput" title="Scan dari gambar">ðŸ“‚</label>
          <input id="fileInput" type="file" accept="image/*" hidden>
        </div>
      </div>

      <div class="grid">
        <div class="pane">
          <div id="reader"></div>
          <div class="overlay"><div class="box"><div class="laser"></div></div></div>
        </div>
        <div class="pane">
          <div style="padding:16px">
            <h3>Hasil Scan</h3>
            <div id="output" class="log">Belum ada hasilâ€¦</div>
            <div class="stat">ðŸ‘¥ Peserta hadir: <b id="count">?</b></div>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="modal" id="modal">
    <div class="sheet">
      <div class="avatar"><img id="avatarImg" alt=""></div>
      <div class="big" id="welcomeTitle">Selamat datang!</div>
      <p class="hint" id="welcomeHint">Telah melakukan register Enjoy ðŸ«°</p>
      <div class="countdown" id="countdown">Menyegarkan halaman dalam 5â€¦</div>
      <button class="btn" id="btnClose">Tutup sekarang</button>
    </div>
  </div>

<script>
  // ===== Helper Avatar dari nama =====
  function avatarFromName(name){
    const initials=(name||'?').split(/\s+/).map(s=>s[0]).filter(Boolean).join('').slice(0,2).toUpperCase();
    const canvas=document.createElement('canvas'); canvas.width=256; canvas.height=256;
    const ctx=canvas.getContext('2d');
    const hue=(Array.from(name||'').reduce((a,c)=>a+c.charCodeAt(0),0))%360;
    const grad=ctx.createLinearGradient(0,0,256,256);
    grad.addColorStop(0,`hsl(${hue},80%,55%)`);
    grad.addColorStop(1,`hsl(${(hue+60)%360},80%,45%)`);
    ctx.fillStyle=grad; ctx.fillRect(0,0,256,256);
    ctx.fillStyle='#fff'; ctx.font='bold 120px -apple-system,Segoe UI,Roboto,Arial';
    ctx.textAlign='center'; ctx.textBaseline='middle';
    ctx.fillText(initials||'?',128,128);
    return canvas.toDataURL();
  }

  // ===== Modal =====
  const modal=document.getElementById('modal');
  const avatarImg=document.getElementById('avatarImg');
  const welcomeTitle=document.getElementById('welcomeTitle');
  const welcomeHint=document.getElementById('welcomeHint');
  const countdownEl=document.getElementById('countdown');
  const btnClose=document.getElementById('btnClose');
  btnClose.onclick=()=>location.reload();

  function showSuccess(name,count){
    welcomeTitle.textContent = name ? `Selamat datang, ${name}!` : `Berhasil!`;
    avatarImg.src = avatarFromName(name||'Guest');
    welcomeHint.textContent = `Tercatat hadir. Total hadir: ${count}.`;
    modal.classList.add('show');
    let s=5;
    countdownEl.textContent=`Menyegarkan halaman dalam ${s}â€¦`;
    const iv=setInterval(()=>{
      s--; countdownEl.textContent=`Menyegarkan halaman dalam ${s}â€¦`;
      if(s<=0){ clearInterval(iv); location.reload(); }
    },1000);
  }

  // ===== Parser payload QR (VERSI JSON dari registrasi) =====
  // Contoh payload:
  // {"type":"registration","version":1,"ts":"2025-10-15T09:04:05.000Z","nama":"SCARDFLASHER","wa":"+6282132687740","gender":"Pria","gereja":"GKI","alamat":"Oke"}
  function parseQR(text) {
    try {
      const obj = JSON.parse(text);
      if (obj && obj.type === 'registration') {
        // Normalisasi gender ringan (opsional)
        let gender = (obj.gender || '').trim();
        const gl = gender.toLowerCase();
        if (['l','laki','male','m','pria','cowok'].includes(gl)) gender = 'Pria';
        else if (['p','perempuan','female','f','wanita','cewek'].includes(gl)) gender = 'Wanita';
        return {
          nama: (obj.nama || '').trim(),
          wa: (obj.wa || '').trim(),
          gender,
          gereja: (obj.gereja || '').trim(),
          alamat: (obj.alamat || '').trim()
        };
      }
    } catch (e) {
      // Jika bukan JSON, biarkan kosong (tidak mengubah UI)
    }
    return { nama:'', wa:'', gender:'', gereja:'', alamat:'' };
  }

  // ===== UI dan Scanner =====
  const out=document.getElementById('output');
  const countEl=document.getElementById('count');
  let reader; let cameras=[]; let currentId=null;

  function log(s){ out.textContent = s; }

  async function init(){
    try{
      cameras = await Html5Qrcode.getCameras();
    }catch(e){ console.warn(e); }
    const select=document.getElementById('cameraSelect');
    select.innerHTML='';
    if(cameras.length){
      cameras.forEach((c,i)=>{
        const o=document.createElement('option'); o.value=c.id; o.textContent=c.label||`Kamera ${i+1}`;
        select.appendChild(o);
      });
      const back = cameras.find(c=>/back|rear|belakang|environment/i.test(c.label||'')) || cameras[0];
      currentId = back.id;
      select.value = currentId;
      start(currentId);
    }else{
      const o=document.createElement('option'); o.textContent='Tidak ada kamera';
      select.appendChild(o);
    }
    select.onchange=e=>start(e.target.value);
    document.getElementById('btnSwitch').onclick=()=>{
      if(!cameras.length) return;
      const idx=cameras.findIndex(c=>c.id===currentId);
      const next=cameras[(idx+1)%cameras.length];
      select.value=next.id; start(next.id);
    };
    document.getElementById('fileInput').onchange=async ev=>{
      const f=ev.target.files[0];
      if(!f) return;
      try{
        if(reader && reader.isScanning){
            await reader.stop();
        }
        const res = await reader.scanFile(f,true);
        onScan(res);
      }catch(err){ log('Gagal membaca gambar: '+err); }
      ev.target.value='';
    };
  }

  async function start(id){
    if(reader){ try{ await reader.stop(); }catch{} }
    reader=new Html5Qrcode("reader", {formatsToSupport:[Html5QrcodeSupportedFormats.QR_CODE]});
    currentId=id;
    const config = { fps:12, qrbox: (w,h)=> {
      const min = Math.min(w,h);
      const size = Math.min(Math.max(260, min*0.65), 420);
      return {width:size, height:size};
    }};
    reader.start({deviceId:{exact:id}}, config, onScan, ()=>{});
  }

  async function onScan(decodedText){
    try{ reader.pause(true); }catch{}
    log(decodedText);

    const { nama, wa, gender, gereja, alamat } = parseQR(decodedText);

    // Minimal guard: wajib ada wa
    if (!wa) {
      alert('QR tidak valid: WA kosong.');
      try{ reader.resume(); }catch{}
      return;
    }

    try{
      const res = await fetch('save.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify({ nama, wa, gender, gereja, alamat })
      });
      const data = await res.json();
      if(data && data.ok){
        countEl.textContent = (typeof data.count !== 'undefined') ? data.count : countEl.textContent;
        showSuccess(nama || 'Peserta', data.count ?? 'â€”');
      }else{
        alert('Gagal menyimpan: ' + (data && data.error ? data.error : 'unknown'));
        try{ reader.resume(); }catch{}
      }
    }catch(err){
      alert('Koneksi gagal: '+err);
      try{ reader.resume(); }catch{}
    }
  }

  window.addEventListener('load', init);
</script>
</body>
</html>